function NavRuleConditionAggregator()
{
	this.combine = null;
	this.conditions = null;
	this.operator = null;
	this.events = null;
	
	this.setDefaultValues();
}
NavRuleConditionAggregator.prototype.loadFromXMLNode = NavRuleConditionAggregatorLoadFromXMLNode;
NavRuleConditionAggregator.prototype.setDefaultValues = NavRuleConditionAggregatorSetDefaultValues;
NavRuleConditionAggregator.prototype.toString = NavRuleConditionAggregatorToString;
NavRuleConditionAggregator.prototype.resolveReferences = NavRuleConditionAggregatorResolveReferences;
NavRuleConditionAggregator.prototype.registerEvent = RegisterEvent;
NavRuleConditionAggregator.prototype.changed = NavRuleConditionAggregatorChanged;
NavRuleConditionAggregator.prototype.evaluate = NavRuleConditionAggregatorEvaluate;
NavRuleConditionAggregator.prototype.clone = NavRuleConditionAggregatorClone;

function NavRuleConditionAggregatorClone()
{
	var retVal = new NavRuleConditionAggregator();
	
	retVal.combine = this.combine;
	retVal.conditions = new Array();
	for (var i=0;i<this.conditions.length;i++)
	{
		retVal.conditions[i] = this.conditions[i].clone();
	}

	retVal.operator = this.operator;
	retVal.events = new EventsObject(DEFAULT_RULE_EVENTS);
		
	return retVal;
}

function NavRuleConditionAggregatorChanged(ref)
{
	this.events.raiseEvent("changed",this);
}

function NavRuleConditionAggregatorResolveReferences(navRef)
{	
	for (var i=0;i<this.conditions.length;i++)
	{
		this.conditions[i].resolveReferences(navRef);
		this.conditions[i].registerEvent("changed","changed",this,null,true);
	}
}

function NavRuleConditionAggregatorToString()
{
	var str = "(" + ((this.operator==NAV_OPERATOR_NOT)?("not ("):(""));
	var strOp = ((this.combine==NAV_COMBINE_AND)?("and"):("or"));
	
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].toString() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")) + ")";
	return str;
}

function NavRuleConditionAggregatorEvaluate()
{
	var str = "(" + ((this.operator==NAV_OPERATOR_NOT)?("!("):(""));
	var strOp = ((this.combine==NAV_COMBINE_AND)?("&&"):("||"));
	
	for (var i=0;i<this.conditions.length;i++)
	{
		str += this.conditions[i].evaluate() + ((i<this.conditions.length-1)?(" " + strOp + " "):(""));
	}
	
	str += ((this.operator==NAV_OPERATOR_NOT)?(")"):("")) + ")";
	return eval(str);
}

function NavRuleConditionAggregatorSetDefaultValues()
{
	this.combine = NAV_COMBINE_AND;
	this.conditions = new Array();
	this.operator = NAV_OPERATOR_NO_OP;
	this.events = new EventsObject(DEFAULT_RULE_EVENTS);
}

function NavRuleConditionAggregatorLoadFromXMLNode(xmlNode)
{
	this.setDefaultValues();
	
	var combine = xmlNode.tagName;
	switch (combine.toLowerCase())
	{
		case "condand":this.combine = NAV_COMBINE_AND;break;
		case "condor":this.combine = NAV_COMBINE_OR;break;
	}
	
	for (var i=0;i<xmlNode.children.length;i++)
	{
		if (xmlNode.children[i].nodeType == "ELEMENT")
		{
			var isAggregator;
			var objTemp;
			var nodeName = xmlNode.children[i].tagName.toLowerCase();
			
			if (nodeName == "condand" || nodeName == "condor")
			{
				objTemp = new NavRuleConditionAggregator();
			}
			else
			{
				objTemp = new NavRuleCondition();
			}
			objTemp.loadFromXMLNode(xmlNode.children[i]);
			this.conditions[this.conditions.length] = objTemp;
		}
	}
	
	var operator = xmlNode.getAttribute("operator");
	switch ((operator+"").toLowerCase())
	{
		case "not":this.operator = NAV_OPERATOR_NOT;break;
		case "noop":this.operator = NAV_OPERATOR_NO_OP;break;
		default:this.operator = NAV_OPERATOR_NO_OP;break;
	}
}
